/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.util.StackListFluid;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class StorageDiskFluid
implements IStorageDisk<FluidStack> {
    public static final String NBT_VERSION = "Version";
    public static final String NBT_CAPACITY = "Capacity";
    public static final String NBT_FLUIDS = "Fluids";
    public static final String NBT_REAL_SIZE = "RealSize";
    private final World world;
    private final long capacity;
    private long stored;
    private final Map<StackListFluid.FluidStackWrapper, StackListEntry<FluidStack>> stacks = new ConcurrentHashMap<StackListFluid.FluidStackWrapper, StackListEntry<FluidStack>>();
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public StorageDiskFluid(@Nullable World world, long capacity) {
        this.world = world;
        this.capacity = capacity;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (StackListEntry<FluidStack> entry : this.stacks.values()) {
            NBTTagCompound stackTag = new NBTTagCompound();
            entry.getStack().writeToNBT(stackTag);
            stackTag.func_74772_a(NBT_REAL_SIZE, entry.getCount());
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74778_a(NBT_VERSION, "2.3.1");
        tag.func_74782_a(NBT_FLUIDS, (NBTBase)list);
        tag.func_74772_a(NBT_CAPACITY, this.capacity);
        return tag;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.stacks.values().stream().map(StackListEntry::getStack).collect(Collectors.toList());
    }

    @Override
    public Collection<StackListEntry<FluidStack>> getEntries() {
        return this.stacks.values();
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> insert(@Nonnull FluidStack stack, long size, Action action) {
        StackListFluid.FluidStackWrapper wrapper = new StackListFluid.FluidStackWrapper(stack);
        StackListEntry<FluidStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            if (this.getCapacity() != -1L && this.getStored() + size > this.getCapacity()) {
                long remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0L) {
                    return new StackListResult<FluidStack>(stack.copy(), size);
                }
                if (action == Action.PERFORM) {
                    entry.grow(remainingSpace);
                    this.stored += remainingSpace;
                    this.onChanged();
                }
                return new StackListResult<FluidStack>(entry.getStack().copy(), size - remainingSpace);
            }
            if (action == Action.PERFORM) {
                entry.grow(size);
                this.stored += size;
                this.onChanged();
            }
            return null;
        }
        if (this.getCapacity() != -1L && this.getStored() + size > this.getCapacity()) {
            long remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0L) {
                return new StackListResult<FluidStack>(stack.copy(), size);
            }
            wrapper.setStack(stack.copy());
            if (action == Action.PERFORM) {
                this.stacks.put(wrapper, new StackListEntry<FluidStack>(stack.copy(), remainingSpace));
                this.stored += remainingSpace;
                this.onChanged();
            }
            return new StackListResult<FluidStack>(wrapper.getStack(), size - remainingSpace);
        }
        if (action == Action.PERFORM) {
            wrapper.setStack(stack.copy());
            this.stacks.put(wrapper, new StackListEntry<FluidStack>(stack.copy(), size));
            this.stored += size;
            this.onChanged();
        }
        return null;
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> extract(@Nonnull FluidStack stack, long size, int flags, Action action) {
        StackListFluid.FluidStackWrapper wrapper = new StackListFluid.FluidStackWrapper(stack);
        StackListEntry<FluidStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            if (size > entry.getCount()) {
                size = entry.getCount();
            }
            if (action == Action.PERFORM) {
                if (entry.getCount() - size == 0L) {
                    this.stacks.remove(wrapper, entry);
                    this.stored -= entry.getCount();
                } else {
                    entry.shrink(size);
                    this.stored -= size;
                }
                this.onChanged();
            }
            return new StackListResult<FluidStack>(entry.getStack().copy(), size);
        }
        return null;
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    public void calculateStoredAmount() {
        this.stored = this.stacks.values().stream().mapToLong(StackListEntry::getCount).sum();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0L;
        }
        return remainder < 1L ? size : size - remainder;
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public String getId() {
        return "normal_fluid";
    }

    public Map<StackListFluid.FluidStackWrapper, StackListEntry<FluidStack>> getRawStacks() {
        return this.stacks;
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        if (this.world != null) {
            API.instance().getStorageDiskManager(this.world).markForSaving();
        }
    }
}

